﻿using System;
using System.IO;
using System.Threading;

namespace CSharpBuch.Kap18
{
  class Aufgabe2
  {
    static void Main(string[] args)
    {
      int startZeit = Environment.TickCount;

      string logDir = "log";
      string logFileName = "Laufzeit.txt";
      string appDir;
      string appName;

      appDir = Path.GetDirectoryName(Environment.GetCommandLineArgs()[0]);
      appName = Path.GetFileName(Environment.GetCommandLineArgs()[0]);

      if (!Directory.Exists(logDir))
        Directory.CreateDirectory(logDir);

      logDir = Path.Combine(appDir, logDir);

      if (!Directory.Exists(logDir))
        Directory.CreateDirectory(logDir);

      // Etwas Verarbeitungszeit simulieren
      Random rd = new Random(DateTime.Now.Millisecond);
      Thread.Sleep(rd.Next(1000) + 1);

      // Datei öffnen
      string dateiname = Path.Combine(logDir, logFileName);
      FileStream fsWrite = new FileStream(dateiname, FileMode.Append,
                                         FileAccess.Write);
      TextWriter tw = new StreamWriter(fsWrite);

      int endZeit = Environment.TickCount;
      tw.WriteLine("{0}: Dauer der Ausführung {1}", appName, endZeit - startZeit);

      tw.Close();

      Console.ReadLine();
    }
  }
}